//////////////////////////////////////
//                                  //
//          navigation.js           // 
//                                  //
//////////////////////////////////////
ENABLE_ERROR_TRAPPING = true;
ENABLE_ERROR_MESSAGES = true;
////////////////////////////
// Navigational Functions //
////////////////////////////

/////////////////////////////////////////////////////////////
//    General comments about the navigational code:        //
/////////////////////////////////////////////////////////////
// Navigational state is controlled through                //
// three state variables, 'section', 'topic', and 'page'.  //
// 'section' and 'page' are integers while 'topic'         //
// is a variant.  'topic' will be either an integer        //
// representing a topic, such as 2, or a string            //
// representing a subtopic, such as '2c'.                  //
//                                                         //
// The process used by the functions defined below         //
// to navigate is as follows:                              // 
//                                                         //
// 1. Set the state variables to reflect the page          //
//    to be navigated to.                                  //
// 2. Call the nav() function and pass it the              //
//    relative path to the html file.                      //
//                                                         //
// The only exception to this is the goBack() function     //
// which loads the page itself.  This is done              //
// because the nav() function is used not only             //
// to navigate, but also to keep track of where            //
// navigation has progressed.  Since the goBack()          //
// function is only concerned with loading the             //
// page, and not recording it in the history,              //
// the function loads the page on its own.                 //
/////////////////////////////////////////////////////////////

///////////////////////////////////////////
//    Navigation Access State Function   //
///////////////////////////////////////////
// The functions below are used to set or query the
// completion state, locked state, or prerequisites
// for a page or topic in the courseware module.
////////////////////////////////////////////////////
// NOTE: The "subtopic" parameter required by the functions
// below is an integer representation of the desired
// subtopic.  0 represents no subtopic.  1 represents
// subtopic a, 2 represents subtopic b ....

var disableNavControllerSave = false;

function loadNavControllerData()
{
	navController.load(getVar("NC"));
} 

function saveNavControllerData()
{
	if (disableNavControllerSave)
	{
		return;
	}
	else if (navController.isDirty())
	{
		setVar("NC", navController.dump());
	}
}

function markPageComplete(section, topic, subtopic, page)
{
	// Check for correct number of arguments.
	if (markPageComplete.arguments.length != 4)
	{
		alert("Function call markPageComplete(section, topic, subtopic, page) requires 4 parameters!");
		return;
	}
	// Mark the specified page as complete.
	navController.setPageCompletionState(new Page(section, topic, subtopic, page), true);
	// Check to see if the entire topic that the page belongs
	// to has been completed.
	if (navController.checkForTopicCompletion(new Topic(section, topic, subtopic)))
	{
		// Mark the specified topic as complete.
		navController.setTopicCompletionState(new Topic(section, topic, subtopic), true);
		// If the current topic is a subtopic, then let's
		// go ahead and check to see if its owner topic
		// is also complete.
		if (subtopic > 0)
		{
			if (navController.checkForTopicCompletion(new Topic(section, topic, 0)))
			{
				// Mark the specified topic as complete.
				navController.setTopicCompletionState(new Topic(section, topic, 0), true);
			}	
		}
	}
	// Check to see if entire module is complete.
	if (moduleIsComplete())
	{
		if (LMSGetValue("cmi.core.lesson_status") == "incomplete")
		{
			LMSSetValue("cmi.core.lesson_status","completed");
		}
	}
	// Save navigation data to the suspendData object.
	saveNavControllerData();
}
		
function moduleIsComplete()
{
	for (var i=0;i<sectionTitles.length;i++)
	{
		for (var t=0;t<topicTitles[i].length;t++)
		{
			var top = new Topic((i+1),(t+1),0);
			if (!navController.getTopicCompletionState(top))
			{
				return false;
			}
		}
	}
	return true;
}
		
function markPageIncomplete(section, topic, subtopic, page)
{
	// Check for correct number of arguments.
	if (markPageIncomplete.arguments.length != 4)
	{
		alert("Function call markPageIncomplete(section, topic, subtopic, page) requires 4 parameters!");
		return;
	}
	// Mark the specified page as incomplete.
	navController.setPageCompletionState(new Page(section, topic, subtopic, page), false);

	// Mark the specified topic as incomplete.
	navController.setTopicCompletionState(new Topic(section, topic, 0), false);
	if (subtopic > 0)
	{
		navController.setTopicCompletionState(new Topic(section, topic, subtopic), false);
	}

	// Save navigation data to the suspendData object.
	saveNavControllerData();
}

function setSameTopicMultiplePagePrerequisites(section, topic, subtopic, page)
{
	if (setSameTopicMultiplePagePrerequisites.arguments.length < 5)
	{
		alert("Function call setSameTopicMultiplePagePrerequisites(targetSection, targetTopic, targetSubtopic, targetPage, +prereqPage) requires at least 5 parameters!");
		return;
	}
	
	for (var i=4;i<setSameTopicMultiplePagePrerequisites.arguments.length;i++)
	{
		navController.setPrerequisites(new Page(section, topic, subtopic, page), new Page(section, topic, subtopic, setSameTopicMultiplePagePrerequisites.arguments[i]));
	}
	saveNavControllerData();
}

function setPagePrerequisite(targetSection, targetTopic, targetSubtopic, targetPage, prereqSection, prereqTopic, prereqSubtopic, prereqPage)
{
	if (setPagePrerequisite.arguments.length < 7 || setPagePrerequisite.arguments.length > 8)
	{
		alert("Function call setPagePrerequisite(targetSection, targetTopic, targetSubtopic, targetPage, prereqSection, prereqTopic, prereqSubtopic, prereqPage) requires at least 7 parameters and no more than 8!");
		return;
	}
	if (setPagePrerequisite.arguments.length == 7)
	{
		navController.setPrerequisites(new Page(targetSection, targetTopic, targetSubtopic, targetPage), new Topic(prereqSection, prereqTopic, prereqSubtopic));
	}
	else
	{
		navController.setPrerequisites(new Page(targetSection, targetTopic, targetSubtopic, targetPage), new Page(prereqSection, prereqTopic, prereqSubtopic, prereqPage));
	}
	saveNavControllerData();
}

function setTopicPrerequisite(targetSection, targetTopic, targetSubtopic, prereqSection, prereqTopic, prereqSubtopic, prereqPage)
{
	if (setTopicPrerequisite.arguments.length < 6 || setTopicPrerequisite.arguments.length > 7)
	{
		alert("Function call setTopicPrerequisite(targetSection, targetTopic, targetSubtopic, prereqSection, prereqTopic, prereqSubtopic, prereqPage) requires at least 6 parameters and no more than 7!");
		return;
	}
	if (setTopicPrerequisite.arguments.length == 6)
	{
		navController.setPrerequisites(new Topic(targetSection, targetTopic, targetSubtopic), new Topic(prereqSection, prereqTopic, prereqSubtopic));
	}
	else
	{
		navController.setPrerequisites(new Topic(targetSection, targetTopic, targetSubtopic), new Page(prereqSection, prereqTopic, prereqSubtopic, prereqPage));
	}
	saveNavControllerData();
}

function getPageState(section, topic, subtopic, page)
{
	if (getPageState.arguments.length != 4)
	{
		alert("Function call getPageState(section, topic, subtopic, page) takes 4 parameters!");
		return;
	}
	return navController.getPageCompletionState(new Page(section, topic, subtopic, page));
}

function getTopicState(section, topic, subtopic)
{
	if (getTopicState.arguments.length != 3)
	{
		alert("Function call getTopicState(section, topic, subtopic) takes 3 parameters!");
		return;
	}
	return navController.getTopicCompletionState(new Topic(section, topic, subtopic));
}

function hidePage(section, topic, subtopic, page)
{
	if (hidePage.arguments.length != 4)
	{
		alert("The function hidePage(section, topic, subtopic, page) requires 4 parameters!");
		return;
	}
	navController.setPageHiddenState(new Page(section, topic, subtopic, page), true);
	saveNavControllerData();
}

function showPage(section, topic, subtopic, page)
{
	if (showPage.arguments.length != 4)
	{
		alert("The function showPage(section, topic, subtopic, page) requires 4 parameters!");
		return;
	}
	navController.setPageHiddenState(new Page(section, topic, subtopic, page), false);
	saveNavControllerData();
}

function hideTopic(section, topic, subtopic)
{
	if (hideTopic.arguments.length != 3)
	{
		alert("The function hideTopic(section, topic, subtopic) requires 3 parameters!");
		return;
	}
	navController.setTopicHiddenState(new Topic(section, topic, subtopic), true);
	saveNavControllerData();
}

function showTopic(section, topic, subtopic)
{
	if (showTopic.arguments.length != 3)
	{
		alert("The function showTopic(section, topic, subtopic) requires 3 parameters!");
		return;
	}
	navController.setTopicHiddenState(new Topic(section, topic, subtopic), false);
	saveNavControllerData();
}

function lockPage(section, topic, subtopic, page)
{
	if (lockPage.arguments.length != 4)
	{
		alert("The function lockPage(section, topic, subtopic, page) requires 4 parameters!");
		return;
	}
	navController.setPageLockedState(new Page(section, topic, subtopic, page), true);
	saveNavControllerData();
}

function unlockPage(section, topic, subtopic, page)
{
	if (unlockPage.arguments.length != 4)
	{
		alert("The function unlockPage(section, topic, subtopic, page) requires 4 parameters!");
		return;
	}
	navController.setPageLockedState(new Page(section, topic, subtopic, page), false);
	saveNavControllerData();
}

function unlockTopic(section, topic, subtopic)
{
	if (unlockTopic.arguments.length != 3)
	{
		alert("The function unlockTopic(section, topic, subtopic) requires 3 parameters!");
		return;
	}
	navController.setTopicLockedState(new Topic(section, topic, subtopic), false);
	saveNavControllerData();
}

function lockTopic(section, topic, subtopic)
{
	if (lockTopic.arguments.length != 3)
	{
		alert("The function lockTopic(section, topic, subtopic) requires 3 parameters!");
		return;
	}
	navController.setTopicLockedState(new Topic(section, topic, subtopic), true);
	saveNavControllerData();
}

// This function can be used to mark all of the pages
// in a topic (or subtopic) as complete.  If subtopic
// 0 is specified, all of the subtopic pages will
// be marked as complete also.  This function will also
// mark the specified topic as complete.
function markEntireTopicComplete(section, topic, subtopic)
{
	if (subtopic == 0) // Entire Topic
	{
		for (var i=0;i<pageTitles[section-1][topic-1].length;i++)
		{
			var objPage = new Page(section, topic, 0, (i+1));
			navController.setPageCompletionState(objPage,true);
		}
		if (subtopicPageTitles != null && subtopicPageTitles[section-1] != null && subtopicPageTitles[section-1][topic-1] != null)
		{
			for (var i=0;i<subtopicPageTitles[section-1][topic-1].length;i++)
			{
				markEntireTopicComplete(section, topic, (i+1));
			}
		}
	}
	else // Subtopic 
	{
		for (var t=0;t<subtopicPageTitles[section-1][topic-1][subtopic-1].length;t++)
		{
			var objPage = new Page(section, topic, subtopic, (t+1));
			navController.setPageCompletionState(objPage,true);
		}
	}
	navController.setTopicCompletionState(new Topic(section, topic, subtopic),true);
	// Check to see if entire module is complete.
	if (moduleIsComplete())
	{
		if (LMSGetValue("cmi.core.lesson_status") == "incomplete")
		{
			LMSSetValue("cmi.core.lesson_status","completed");
		}
	}
	saveNavControllerData();
}

// This function can be used to mark all of the pages
// in a topic (or subtopic) as incomplete.  If subtopic
// 0 is specified, all of the subtopic pages will
// be marked as incomplete also.  This function will also
// mark the specified topic as incomplete.
function markEntireTopicIncomplete(section, topic, subtopic)
{
	if (subtopic == 0) // Entire Topic
	{
		for (var i=0;i<pageTitles[section-1][topic-1].length;i++)
		{
			var objPage = new Page(section, topic, 0, (i+1));
			navController.setPageCompletionState(objPage,false);
		}
		if (subtopicPageTitles != null && subtopicPageTitles[section-1] != null && subtopicPageTitles[section-1][topic-1] != null)
		{
			for (var i=0;i<subtopicPageTitles[section-1][topic-1].length;i++)
			{
				markEntireTopicIncomplete(section, topic, (i+1));
			}
		}
	}
	else // Subtopic 
	{
		for (var t=0;t<subtopicPageTitles[section-1][topic-1][subtopic-1].length;t++)
		{
			var objPage = new Page(section, topic, subtopic, (t+1));
			navController.setPageCompletionState(objPage,false);
		}
	}
	navController.setTopicCompletionState(new Topic(section, topic, subtopic),false);
	saveNavControllerData();
}

// This function will lock all of the pages and
// in a section.  It does not lock the sections or topics.
function lockEntireSection(section)
{
	for (var i=0;i<topicTitles[section-1].length;i++)
	{
		lockEntireTopic(section, (i+1), 0, false);
	}
	saveNavControllerData();
}

// This function will unlock all of the pages in a section.
// It does not unlock the section or topics.
function unlockEntireSection(section)
{
	for (var i=0;i<topicTitles[section-1].length;i++)
	{
		unlockEntireTopic(section, (i+1), 0, false);
	}
	saveNavControllerData();
}

// This function will lock all of the pages in a
// topic.  It does not lock the topic itself.
function lockEntireTopic(section, topic, subtopic, saveNavDataFlag)
{
	if (saveNavDataFlag == null)
	{
		saveNavDataFlag = true;
	}
	if (subtopic == 0) // Entire Topic
	{
		for (var i=0;i<pageTitles[section-1][topic-1].length;i++)
		{
			var objPage = new Page(section, topic, subtopic, (i+1));
			navController.setPageLockedState(objPage, true);
		}
		if (subtopicPageTitles != null && subtopicPageTitles[section-1] != null && subtopicPageTitles[section-1][topic-1] != null)
		{
			for (var i=0;i<subtopicPageTitles[section-1][topic-1].length;i++)
			{
				lockEntireTopic(section, topic, (i+1), saveNavDataFlag);
			}
		}
	}
	else // Subtopic
	{
		for (var t=0;t<subtopicPageTitles[section-1][topic-1][subtopic-1].length;t++)
		{
			var objPage = new Page(section, topic, subtopic, (t+1));
			navController.setPageLockedState(objPage,true);
		}
	}
	//navController.setTopicLockedState(new Topic(section, topic, subtopic),true);
	if (saveNavDataFlag)
	{
		saveNavControllerData();
	}
}

// This function will unlock all of the pages in a
// topic.  It does not unlock the topic itself.
function unlockEntireTopic(section, topic, subtopic, saveNavDataFlag)
{
	if (saveNavDataFlag == null)
	{
		saveNavDataFlag = true;
	}
	if (subtopic == 0) // Entire Topic
	{
		for (var i=0;i<pageTitles[section-1][topic-1].length;i++)
		{
			var objPage = new Page(section, topic, subtopic, (i+1));
			navController.setPageLockedState(objPage, false);
		}
		if (subtopicPageTitles != null && subtopicPageTitles[section-1] != null && subtopicPageTitles[section-1][topic-1] != null)
		{
			for (var i=0;i<subtopicPageTitles[section-1][topic-1].length;i++)
			{
				unlockEntireTopic(section, topic, (i+1), saveNavDataFlag);
			}
		}
	}
	else // Subtopic
	{
		for (var t=0;t<subtopicPageTitles[section-1][topic-1][subtopic-1].length;t++)
		{
			var objPage = new Page(section, topic, subtopic, (t+1));
			navController.setPageLockedState(objPage,false);
		}
	}
	//navController.setTopicLockedState(new Topic(section, topic, subtopic),false);
	if (saveNavDataFlag)
	{
		saveNavControllerData();
	}
}

// Mark a topic complete.
function markTopicComplete(section, topic, subtopic)
{
	if (markTopicComplete.arguments.length != 3)
	{
		alert("The function markTopicComplete(section, topic, subtopic) requires 3 parameters!");
		return;
	}
	navController.setTopicCompletionState(new Topic(section, topic, subtopic), true);
	// Check to see if entire course is complete.
	if (moduleIsComplete())
	{
		if (LMSGetValue("cmi.core.lesson_status") == "incomplete")
		{
			LMSSetValue("cmi.core.lesson_status","completed");
		}
	}
	saveNavControllerData();
}

// Mark a topic complete.
function markTopicIncomplete(section, topic, subtopic)
{
	if (markTopicIncomplete.arguments.length != 3)
	{
		alert("The function markTopicIncomplete(section, topic, subtopic) requires 3 parameters!");
		return;
	}
	navController.setTopicCompletionState(new Topic(section, topic, subtopic), false);
	saveNavControllerData();
}

function showBookmarks()
{
	if (!theBookmarksWindow || theBookmarksWindow.closed)
	     	theBookmarksWindow=window.open("bookmarks.html","Bookmarks","alwaysRaised,toolbar=no,menubar=no,resize=no,width=600,height=400,scrollbars=yes,left=100,top=100,status=no");
	    else theBookmarksWindow.focus();
}

function showActions()
{
	if (!theActionsWindow || theActionsWindow.closed)
	     	theActionsWindow=window.open(actionsLocation,"Actions");
	    else theActionsWindow.focus();
}

function addBookmark(sec, top, pag)
{
	if (addBookmark.arguments.length == 0)
	{
		if ( !bookmarkExists(section, topic, page) )
		{
			bookmarks[bookmarks.length] = new makeNav(section, topic, page);
		}
	}
	else
	{
		if ( !bookmarkExists(sec, top, pag) )
		{
			bookmarks[bookmarks.length] = new makeNav(sec, top, pag);
		}
	}
	// Save bookmark data to suspendData
	updateBookmarkData();
}

function bookmarkExists(sec, top, pag)
{
	if (bookmarkExists.arguments.length == 0)
	{
		for (var i=0;i<bookmarks.length;i++)
		{
			if ( (bookmarks[i].section == section) && (bookmarks[i].topic == topic) && (bookmarks[i].page == page) )
			{
				return true;
			}			
		}
	}
	else
	{
		for (var i=0;i<bookmarks.length;i++)
		{
			if ( (bookmarks[i].section == sec) && (bookmarks[i].topic == top) && (bookmarks[i].page == pag) )
			{
				return true;
			}			
		}
	}
	return false;
}

function deleteBookmark(index)
{
	for (var i=index;i < bookmarks.length-1;i++)
	{
		bookmarks[i] = bookmarks[i+1];
	}
	bookmarks.length--;
	// Save bookmark data to suspendData
	updateBookmarkData();
}

function updateBookmarkData()
{
	var temp = "";
	for (var i=0;i<bookmarks.length-1;i++)
	{
		temp += bookmarks[i].toString() + ",";
	}
	if (bookmarks.length > 0)
	{
		temp += bookmarks[bookmarks.length-1].toString();
	}
	setVar("BM",temp);
}

function loadBookmarkData()
{
	var section, topic, page, index, temp;
	var bks;
	temp = getVar("BM");
	if (temp == null || temp == "")
	{
		return;
	}
	else
	{
		bks = temp.split(",");
	}
	
	for (var i=0;i<bks.length;i++)
	{
		temp = bks[i];
		
		index = temp.indexOf("?");
		section = parseInt(temp.slice(0,index));
		
		temp = temp.slice(index+1,temp.length);
		index = temp.indexOf("?");
		topic = temp.slice(0,index);
	
		temp = temp.slice(index+1,temp.length);
		page = parseInt(temp);
		
		addBookmark(section, topic, page);
	}
}

function printScreen()
{
	if (navigator.appName == 'Netscape' && (window.print==null))
	{
		alert("The printing feature is fully supported in Internet Explorer 5.0.  This feature is not supported in all versions of Netscape Navigator.");
	}
	else if (window.print == null) 
	{
		alert("This feature is fully supported in Internet Explorer 5.0.  In order to print in Internet Explorer 4.0, you must right click on a non-image area of the screen to bring up an action menu, then click on 'print'.");
	}
	else
	{
		parent.Content.focus();
		parent.Content.window.print();
	}
}


function exitCourse()
{
	if (theBookmarksWindow == null || theBookmarksWindow.closed)
	{
	}
	else 
	{
		theBookmarksWindow.close();
	}
	
	if (theMapWindow == null || theMapWindow.closed)
	{
	}
	else 
	{
		theMapWindow.close();
	}
	
	if (theActionsWindow == null || theActionsWindow.closed)
	{
	}
	else 
	{
		theActionsWindow.close();
	}
	
	if (confirmExit())
	{
		parent.Content.location = "exit1.html";
	}
}

function forceClose()
{
	if (theBookmarksWindow == null || theBookmarksWindow.closed)
	{
	}
	    		else 
	{
		theBookmarksWindow.close();
	}
	
	if (theMapWindow == null || theMapWindow.closed)
	{
	}
	else 
	{
		theMapWindow.close();
	}
	
	if (theActionsWindow == null || theActionsWindow.closed)
	{
	}
	else 
	{
		theActionsWindow.close();
	}
	
	parent.Content.location = "exit1.html";
}

// pageLoaded() is called by the page in the 
// Content frame upon the onLoad event.  pageLoaded()
// performs checks on the page in the Content frame to 
// see if it has certain standard components.  It then
// initializes the toolbar or the Content page accordingly.
function pageLoaded()
{
	
	// Show status in status window.
	updateStatus();
	if (inSubtopic())
	{
		enableNextButton();
		enableBackButton();
	}
	else
	{
		// Enable the GOTO, BACK, coursemap and NEXT buttons.
		if (page < getNumPages())
		{
			enableNextButton();
		}
		else
		{
			disableNextButton();
		}
		if (page > 1)
		{
			enableBackButton();
		}
		else
		{
			disableBackButton();
		}
	}
	enableForLoad();
	
	//Enable the PRINT and BOOKMARK buttons
	enablePrint();
	enableBookmark();
	
	// Check for the More Box Layers.  If they are all
	// there, then call enableMore().
	var moreBack = getLayerRef('MoreBack',parent.Content.document);
	var moreText = getLayerRef('MoreText',parent.Content.document);
	var moreImage = getLayerRef('MoreImage',parent.Content.document);
	if ( (parent.Content.moreBox == true) && ( moreBack != null ) && ( moreText != null ) && ( moreImage != null ) )
		enableMore();
	
	// Check to see if this is a video page.
	var videoLayer = getLayerRef('VideoLayer', parent.Content.document);
	if (videoLayer != null)
		enterVideoPage();
		
	// Check to see if this is an audio page
	var audioClip
	audioClip = G2_getClipRef("AUDIO_CLIP",parent.Content.document);
	
	if (audioClip != null || parent.Content.audioReference != null)
		enterAudioPage();
	
	// Set flag to let toolbar know the
	// page is loaded and ready.
	pageReady = true;
	
	displayCurrentPageNumber();
	
	return true;
}


var pageNumberImageArray = new Array();
for (var i=0;i<30;i++)
{
	pageNumberImageArray[i] = new Image();
	pageNumberImageArray[i].src = "toolbar/p" + (i+1) + ".gif";
}
var blankImage = new Image();
blankImage.src = "toolbar/blank.gif";

function displayCurrentPageNumber()
{
	getImageRef("pageNumberImage").src = pageNumberImageArray[page-1].src;
	getImageRef("numPagesImage").src = pageNumberImageArray[getNumPages()-1].src;
}

function clearCurrentPageNumber()
{
	getImageRef("pageNumberImage").src = blankImage.src;
	getImageRef("numPagesImage").src = blankImage.src;
}

// pageUnloaded() is called by the page in the Content
// frame upon the onUnload event.  This function will 
// undo any toolbar initializations that were made when
// pageLoaded() was called.
function pageUnloaded()
{
	// Called in case a page has called
	// disableNav() and did not call
	// enableNav() before exiting.
	enableNav();

	//Change action button location
	//back to the default.
	actionsLocation = defaultActionsLocation;
	
	// Disable the GOTO, BACK and NEXT buttons.
	disableForLoad();
	
	// Disable the MORE button
	disableMore();
	
	//Disable the PRINT and BOOKMARKS buttons
	disablePrint();
	disableBookmark();
	
	// Check to see if this is a video page.
	if (videoPage)
		exitVideoPage();
		
	// Check to see if this is a video page.
	if (audioPage)
		exitAudioPage();
	
	// Kill all animation Timers
	killTimers();
	
	pageReady = false;	
	clearCurrentPageNumber();
	return null;
}

function updateStatus()
{
	if (atIntro) return;
	parent.Content.window.status = 'Page ' + page + ' of ' + getNumPages();
	window.status = 'Page ' + page + ' of ' + getNumPages();
}

function disableGoto()
{
	pageReady = false;
	theGotoButton.src=imageArray[GOTO_IMG + 3].src;
}

function disablePrint()
{
	printReady = false;
	thePrintButton.src=imageArray[PRINT_IMG + 3].src;
}

function enablePrint()
{
	printReady = true;
	thePrintButton.src=imageArray[PRINT_IMG].src;
}

function disableBookmark()
{
	bookmarkReady = false;
	theBookmarkButton.src=imageArray[BOOKMARK_IMG + 3].src;
}

function enableBookmark()
{
	bookmarkReady = true;
	theBookmarkButton.src=imageArray[BOOKMARK_IMG].src;
}

function disableActionsButton()
{
	disableActions = true;
	theActionsButton.src=imageArray[ACTIONS_IMG + 3].src;
}

function enableActionsButton()
{
	disableActions = false;
	theActionsButton.src=imageArray[ACTIONS_IMG].src;
}

function setActionsLocation(loc)
{
	actionsLocation = loc;
	if (theActionsWindow != null && !theActionsWindow.closed)
	{
		theActionsWindow.close();
	}
}

function setDefaultActionsLocation(loc)
{
	actionsLocation = defaultActionsLocation = loc;
	setVar("ActLoc",loc);
	if (theActionsWindow != null && !theActionsWindow.closed)
	{
		theActionsWindow.close();
	}
}

function loadDefaultActionsLocation()
{
	var temp = null;
	temp = getVar("ActLoc");
	if (temp != null && temp != "")
	{
		actionsLocation = defaultActionsLocation = temp;
	}
}

function enableGoto()
{
	theGotoButton.src=imageArray[GOTO_IMG].src;
}

function disableNavigationButtons()
{
	disableFlag = true;
	theBackButton.src=imageArray[BACK_IMG + 3].src;
	theNextButton.src=imageArray[NEXT_IMG + 3].src;
	theGotoButton.src=imageArray[GOTO_IMG + 3].src;
	disableRefreshButton();
	disableCourseMapButton();
}

function enableNavigationButtons()
{
	disableFlag = false;
	if (backButtonEnabled)
		theBackButton.src=imageArray[BACK_IMG].src;
	if (nextButtonEnabled)
		theNextButton.src=imageArray[NEXT_IMG].src;
	theGotoButton.src=imageArray[GOTO_IMG].src;
	enableRefreshButton();
	enableCourseMapButton();
}

function disableForLoad()
{
	disableFlag = true;
	theBackButton.src=imageArray[BACK_IMG + 3].src;
	theNextButton.src=imageArray[NEXT_IMG + 3].src;
	theGotoButton.src=imageArray[GOTO_IMG + 3].src;
}

function enableForLoad()
{
	disableFlag = false;
	if (backButtonEnabled)
		theBackButton.src=imageArray[BACK_IMG].src;
	if (nextButtonEnabled)
		theNextButton.src=imageArray[NEXT_IMG].src;
	theGotoButton.src=imageArray[GOTO_IMG].src;
	enableRefreshButton();
	enableCourseMapButton();
}

function disableHistoryButton()
{
	disableHistory = true;
	theHistoryButton.src=imageArray[HISTORY_IMG + 3].src;
}

function enableHistoryButton()
{
	disableHistory = false;
	theHistoryButton.src=imageArray[HISTORY_IMG].src;
}

function disableCourseMapButton()
{
	disableCourseMap = true;
	theCourseMapButton.src=imageArray[COURSEMAP_IMG + 3].src;
}

function enableCourseMapButton()
{
	disableCourseMap = false;
	theCourseMapButton.src=imageArray[COURSEMAP_IMG].src;
}

function refresh()
{
	if (!disableFlag)
	{
		refreshFlag = true;
		nav("section" + section + "/" + section + "t" + topic + "p" + page + ".html");
	}
}

function enterAudioPage()
{
	audioPage = true;
	theAudioButton.src = imageArray[AUDIO_IMG].src;
	//audioTimerId = setInterval("audioPulse()",1000);
}

function exitAudioPage()
{
	audioPage = false;
	//clearInterval(audioTimerId);
	theAudioButton.src = imageArray[AUDIO_IMG + 3].src;
}

function enterVideoPage()
{
	if (disableVideo) return;
	videoPage = true;
	theVideoButton.src = imageArray[VIDEO_IMG].src;
	//videoTimerId = setInterval("videoPulse()",1000);
}

function disableVideoButton()
{
	disableVideo = true;
	exitVideoPage();
}

function enableVideoButton()
{
	disableVideo = false;
	enterVideoPage();
}

function disableAudioButton()
{
	exitAudioPage();
}

function enableAudioButton()
{
	enterAudioPage();
}

function exitVideoPage()
{
	videoPage = false;
	//clearInterval(videoTimerId);
	theVideoButton.src = imageArray[VIDEO_IMG + 3].src;
}

// Called when MORE button is clicked.
function more()
{
	if (!disableMoreButton)
	{
		//layerToFront('MoreShadow', parent.Content.document);
		layerToFront('MoreBack', parent.Content.document);
		layerToFront('MoreText', parent.Content.document);
		layerToFront('MoreImage', parent.Content.document);
		//showLayer('MoreShadow', parent.Content.document);
		showLayer('MoreBack', parent.Content.document);
		showLayer('MoreImage', parent.Content.document);
		showLayer('MoreText', parent.Content.document);
	}
}

// Called by the Content frame whenever a
// MORE box is available.  This function
// simply enables the MORE button.
function enableMore()
{
	disableMoreButton = false;
	theMoreButton.src = imageArray[MORE_IMG].src;
	//moreTimerId = setInterval("morePulse()",1000);
}

function killTimers()
{
	disableMore();
	
	exitVideoPage();
	exitAudioPage();
	
	for (var i=0;i<animArray.length;i++)
		killAnimation(animArray[i].timerId);
	animArray = new Array();

}

// Called by the Content frame whenever a
// MORE box becomes unavailable.  This function
// simply disables the MORE button.
function disableMore()
{
	disableMoreButton = true;
	//clearInterval(moreTimerId);
	theMoreButton.src = imageArray[MORE_IMG + 3].src;
}

// Called by course pages in the Content frame
// to disable navigation.
function disableNav()
{
	disableForContent = true;
}

// Called by course pages in the Content frame
// to enable navigation.
function enableNav()
{
	disableForContent = false;
}

// This function will check to see if a page
// is currently accessible (has all prerequisites
// met, and is not locked).  If the page is not
// accessible, a message box will prompt the user
// with a message telling them so, and the function
// will return false.  If the page is accessible
// there will be no message, and the function
// will return true.
function checkPageAccessStatus(sec, top, pg)
{
	var subNumber = 0;
	if (isSubtopic(top))
	{
		var subChar = getSubtopicString(top);
		subNumber = getSubtopic(subChar) + 1;
	}
	
	var objPage = new Page(sec, parseInt(top), subNumber, pg);
	var objTopic = new Topic(sec, parseInt(top), subNumber);
	var objMainTopic = new Topic(sec, parseInt(top), 0);
	if (!navController.metAllPrerequisites(objPage))
	{
		var prereqArray = parent.Toolbar.navController.getIncompletePrerequisites(objPage);
		var prereqMessage = "You cannot enter this page (Section " + sec + ", Topic " + top + ", Page " + pg  + ") until the following areas of the lesson have been successfully completed:\n";
		for (var y=0;y<prereqArray.length;y++)
		{
			if (prereqArray[y].type == "Page")
			{
				prereqMessage += "\nSection " + prereqArray[y].section + ", Topic " + prereqArray[y].topic + ((prereqArray[y].subtopic > 0)?(String.fromCharCode(prereqArray[y].subtopic+96)):("")) + ", Page " + prereqArray[y].page;
			}
			else
			{
				prereqMessage += "\nSection " + prereqArray[y].section + ", Topic " + prereqArray[y].topic + ((prereqArray[y].subtopic > 0)?(String.fromCharCode(prereqArray[y].subtopic+96)):(""));
			}
		}
		alert(prereqMessage);
		updateStatus();
		return false;
	}	
	else if (!navController.metAllPrerequisites(objTopic))
	{
		var prereqArray = parent.Toolbar.navController.getIncompletePrerequisites(objTopic);
		var prereqMessage = "You cannot enter this Topic (Section " + sec + ", Topic " + top + ", subtopic " + subNumber + ") until the following areas of the lesson have been successfully completed:\n";
		for (var y=0;y<prereqArray.length;y++)
		{
			if (prereqArray[y].type == "Page")
			{
				prereqMessage += "\nSection " + prereqArray[y].section + ", Topic " + prereqArray[y].topic + ((prereqArray[y].subtopic > 0)?(String.fromCharCode(prereqArray[y].subtopic+96)):("")) + ", Page " + prereqArray[y].page;
			}
			else
			{
				prereqMessage += "\nSection " + prereqArray[y].section + ", Topic " + prereqArray[y].topic + ((prereqArray[y].subtopic > 0)?(String.fromCharCode(prereqArray[y].subtopic+96)):(""));
			}
		}
		alert(prereqMessage);
		updateStatus();
		return false;
	}	
	else if (!navController.metAllPrerequisites(objMainTopic))
	{
		var prereqArray = parent.Toolbar.navController.getIncompletePrerequisites(objMainTopic);
		var prereqMessage = "You cannot enter this Topic (Section " + sec + ", Topic " + parseInt(top) + ") until the following areas of the lesson have been successfully completed:\n";
		for (var y=0;y<prereqArray.length;y++)
		{
			if (prereqArray[y].type == "Page")
			{
				prereqMessage += "\nSection " + prereqArray[y].section + ", Topic " + prereqArray[y].topic + ((prereqArray[y].subtopic > 0)?(String.fromCharCode(prereqArray[y].subtopic+96)):("")) + ", Page " + prereqArray[y].page;
			}
			else
			{
				prereqMessage += "\nSection " + prereqArray[y].section + ", Topic " + prereqArray[y].topic + ((prereqArray[y].subtopic > 0)?(String.fromCharCode(prereqArray[y].subtopic+96)):(""));
			}
		}
		alert(prereqMessage);
		updateStatus();
		return false;
	}	
	else if (navController.getPageLockedState(objPage))
	{
		alert("You cannot enter this page (Section " + sec + ", Topic " + top + ", Page " + pg  + ") because it is currently locked.");
		updateStatus();
		return false;
	}
	else if (navController.getTopicLockedState(objTopic))
	{
		alert("You cannot enter this topic (Section " + sec + ", Topic " + top + ", subtopic " + subNumber + ") because it is currently locked.");
		updateStatus();
		return false;
	}
	else if (navController.getTopicLockedState(objMainTopic))
	{
		alert("You cannot enter this topic (Section " + sec + ", Topic " + parseInt(top) + ") because it is currently locked.");
		updateStatus();
		return false;
	}
	else if (navController.getTopicHiddenState(objTopic))
	{
		alert("You cannot enter this topic (Section " + sec + ", Topic " + top + ", subtopic " + subNumber + ") because it is currently hidden.");
		updateStatus();
		return false;
	}
	else if (navController.getTopicHiddenState(objMainTopic))
	{
		alert("You cannot enter this topic (Section " + sec + ", Topic " + parseInt(top) + ") because it is currently hidden.");
		updateStatus();
		return false;
	}
	else if (navController.getPageHiddenState(objPage))
	{
		alert("You cannot enter this page (Section " + sec + ", Topic " + top + ", Page " + pg + ") because it is currently hidden.");
		updateStatus();
		return false;
	}

	return true;
}

// Called by documents in the Content frame
// when navigation to another page is desired.
function gotoLink(sec, top, pg)
{
	if (checkPageAccessStatus(sec, top, pg))
	{	
		section = sec;
		topic = top;
		page = pg;
		nav("../section" + section + "/" + section + "t" + topic + "p" + page + ".html");
	}
}

function gotoBookmark(sec, top, pag)
{
	if (checkPageAccessStatus(sec, top, pag))
	{	
		section = sec;
		topic = top;
		page = pag;
		nav("section" + section + "/" + section + "t" + topic + "p" + page + ".html");
	}
}

function historyLink(sec, top, pg)
{
	if (checkPageAccessStatus(sec, top, pg))
	{	
		section = sec;
		topic = top;
		page = pg;
		nav("../section" + section + "/" + section + "t" + topic + "p" + page + ".html");
	}
}

function confirmLeave()
{
	var value;
	value = confirm("You are about to leave without having viewed or completed all of the material on this page.  Click 'OK' to leave, or 'Cancel' to remain on this page.");
	return value;
}

function confirmExit()
{
	var value;
	value = confirm("Are you sure you want to exit this lesson?");
	return value;
}

function isVisiblePage(s, t, p)
{
	var subNumber = 0;
	if (isSubtopic(t))
	{
		var subChar = getSubtopicString(t);
		subNumber = getSubtopic(subChar) + 1;
	}
	var objPage = new Page(s, parseInt(t), subNumber, p);
	if (!navController.getPageHiddenState(objPage) && !navController.getPageLockedState(objPage) && navController.metAllPrerequisites(objPage))
	{
		return true;
	}
	else
	{
		return false;
	}
}

// Called when the history button is clicked.
function goBack()
{
	var s,t,p;
	if (disableForContent)
	{
		if (!confirmLeave()) return;
		else disableForContent = false;
	}	
	
	if ( (!disableHistory) && (navCount > 0) )
	{	
		enableNavigationButtons();
		if (!atIntro) 
		{
			navCount--;
		}
		if (navCount <= 0) disableHistoryButton();
		s = navArray[navCount].section;
		t = navArray[navCount].topic;
		p = navArray[navCount].page;
		if (isVisiblePage(s, t, p))
		{
			section = s;
			topic = t;
			page = p;
			atIntro = false;
			window.parent.Content.location = "section" + section + "/" + section + "t" + topic + "p" + page + ".html";
			updateToolbarStatus();
		}
		else
		{
			goBack();
		}
	}	
}

// Constructs a nav object.
function makeNav(sec, top, pg)
{
	this.section = sec;
	this.topic = top;
	this.page = pg;
	this.toString = navToString;
	
	return this;
}
	
function navToString()
{
	return (this.section + "?" + this.topic + "?" + this.page);
}


// Called when navigation to a new
// page is desired.
function nav(thePage)
{
	window.parent.Content.location=thePage;
	if (thePage != 'course_intro.html')
		if (!refreshFlag)
		{
			atIntro = false;
			navCount++;
			navArray[navCount] = new makeNav(section, topic, page);
			updateToolbarStatus();
		}
		else
		{
			refreshFlag = false;
		}
	else
	{
		atIntro = true;
		clearToolbarStatus();
	}
	if (navCount > 0) enableHistoryButton();
	if (navCount > 14) trimNavArray();
}

// keep navArray under control (<= 20).
function trimNavArray()
{
	for (var i=0; i < 15; i++)
	{
		navArray[i] = navArray[i+1];
	}
	navCount = 14;
}

function getStatus()
{
	var top = topic + "";
	top = top.substring(0,1);
	if (atIntro)
		return "You are currently not in a topic.";
	else
	{
		var theTitle = "";
		for (var i=0;i<topicTitles[section-1][top-1].length;i++)
			if (topicTitles[section-1][top-1].charAt(i) == ' ')
			{
				theTitle = topicTitles[section-1][top-1].substring(i+1,topicTitles[section-1][top-1].length);
				break;
			}
		return theTitle + ": page " + page + " of " + getNumPages();
	}
}


// Called when the NEXT button is pressed.
function navNext()
{
	var currentPage = page;

	if (disableForContent)
	{
		if (!confirmLeave()) return;
		else disableForContent = false;
	}	
	
	if (!disableFlag)
	{
		page++;
	
		// Check to see if we are navigating
		// out of the topic.
		if (page > getNumPages())
		{
			// Check to see if we are currently
			// in a subtopic.
			if (inSubtopic())
			{
				topic = parseInt(topic);
				if (parent.Content.subtopicPage != null)
				{
					subtopicPage[section-1][topic-1] = parent.Content.subtopicPage;
				}
				page = subtopicPage[section-1][topic-1];
				nav("section" + section + "/" + section + "t" + topic + "p" + page + ".html");	
			}
			else
			{
				var theTopic = topic;
				var theTopic = parseInt(theTopic);
			
				page = currentPage;
				//showTopics(section);
				showMap();
				disableNavigationButtons();
				atIntro = true;
				if (navCount > 0) enableHistoryButton();
				if (!(topicTitles[section] == null && topicTitles[section-1][parseInt(topic)] == null))
				{
					G2_stop("AUDIO_CLIP");
					G2_setSourcePlay("AUDIO_CLIP",MCTOPIC);
				}
			}
		}
		else
		{
			var nextPage = findNextVisiblePage(page);
			if (nextPage == null)
			{
				page = getNumPages();
				navNext();
			}
			else if (checkPageAccessStatus(section, topic, nextPage))
			{	
				page = nextPage;
				nav("section" + section + "/" + section + "t" + topic + "p" + page + ".html");
			}
			else
			{
				page = currentPage;
			}
		}
	}
}

function findPreviousVisiblePage(page)
{
	for (var i=page;i>0;i--)
	{
		var subNumber = 0;
		if (isSubtopic(topic))
		{
			var subChar = getSubtopicString(topic);
			subNumber = getSubtopic(subChar) + 1;
		}
		var objPage = new Page(section, parseInt(topic), subNumber, i);
		if (!navController.getPageHiddenState(objPage) && !navController.getPageLockedState(objPage))
		{
			return i;
		}
	}
	
	return null;
}

function findNextVisiblePage(page)
{
	for (var i=page;i<=getNumPages();i++)
	{
		var subNumber = 0;
		if (isSubtopic(topic))
		{
			var subChar = getSubtopicString(topic);
			subNumber = getSubtopic(subChar) + 1;
		}
		var objPage = new Page(section, parseInt(topic), subNumber, i);
		if (!navController.getPageHiddenState(objPage) && !navController.getPageLockedState(objPage))
		{
			return i;
		}
	}
	
	return null;
}

// Called when the BACK button is pressed.
function navBack()
{
	var currentPage = page;

	if (disableForContent)
	{
		if (!confirmLeave()) return;
		else disableForContent = false;
	}	
	
	if (!disableFlag)
	{
		page--;
		
		// Check to see if we are backing 
		// out of the topic.
		if (page < 1)
		{
			// Check to see if we are backing
			// out of a subtopic.
			if (inSubtopic())
			{
				topic = parseInt(topic);
				if (parent.Content.subtopicPage != null)
				{
					subtopicPage[section-1][topic-1] = parent.Content.subtopicPage;
				}
				page = subtopicPage[section-1][topic-1];
				nav("section" + section + "/" + section + "t" + topic + "p" + page + ".html");	
			}
			else
			{	
				var theTopic = topic;
				var theTopic = parseInt(theTopic);
				
				page = currentPage;
				//showTopics(section);
				showMap();
				disableNavigationButtons();
				if (navCount > 0) enableHistoryButton();
				atIntro = true;
				if (!(topicTitles[section] == null && topicTitles[section-1][parseInt(topic)] == null))
				{
					G2_stop("AUDIO_CLIP");
					G2_setSourcePlay("AUDIO_CLIP",MCTOPIC);
				}
			}
		}
		else
		{
			var nextPage = findPreviousVisiblePage(page);
			if (nextPage == null)
			{
				page = 1;
				navBack();
			} 
			else if (checkPageAccessStatus(section, topic, nextPage))
			{	
				page = nextPage;
				nav("section" + section + "/" + section + "t" + topic + "p" + page + ".html");
			}
			else
			{
				page = currentPage;
			}
		}
	}
}

// Called by the Content frame document
// when a subtopic button is pressed.
function subtopicChange(top)
{		
	enableNavigationButtons();
	topic = top;
	page = 1;
			
	nav(section + "t" + topic + "p" + page + ".html");	
}
	
// Called when changing sections.
function sectionChange(sec)
{
	section = sec;
	topic = 1;
	page = 1;
	nav("section" + section + "/" + section + "t" + topic + "p" + page + ".html");			
}

function findNextValidPage(pageTry)
{
	if (pageTry > getNumPages())
	{
		return null;
	}

	var subNumber = 0;
	if (inSubtopic())
	{
		var subChar = getSubtopicString(topic);
		subNumber = getSubtopic(subChar) + 1;
	}
	var objPage = new Page(section, topic, subNumber, pageTry);
	if (!navController.metAllPrerequisites(objPage) || navController.getPageLockedState(objPage) || navController.getPageHiddenState(objPage))
	{
		return findNextValidPage(pageTry+1);
	}
	
	return pageTry;
}	

// Called when changing topics within a section.
function gotoTopic(top)
{
	var temp; 
	topic = top;
	if ((temp = findNextValidPage(1)) == null)
	{
		alert("All pages in this topic are either locked, hidden or their prerequisites have not been met.  Please choose another topic.");
		return;
	}
	page = temp;
	nav("../section" + section + "/" + section + "t" + topic + "p" + page + ".html");			
}

// Called when clicking on a topic link in the course map.
function gotoTopic2(top)
{
	var temp; 
	topic = top;
	if ((temp = findNextValidPage(1)) == null)
	{
		alert("All pages in this topic are either locked, or their prerequisites have not been met.  Please choose another topic.");
		return;
	}
	page = temp;
	nav("section" + section + "/" + section + "t" + topic + "p" + page + ".html");			
}

// Called when navigating to a page
// in the same topic.
function gotoPage(thePage)
{
	if (checkPageAccessStatus(section, topic, thePage))
	{	
		page = thePage;
		nav("../section" + section + "/" + section + "t" + topic + "p" + page + ".html");
	}
}

// Called when the HELP button is clicked.
function showHelp()
{
	var helpWin = window.open("help.html","Help");
}

// This function will simply return
// the number of pages in the current
// Section and topic (or subtopic).
function getNumPages()
{
	if (inSubtopic())
	{
		var subNumber;
		var subChar;
		var subTopic;
			
		subTopic = parseInt(topic);
		subChar = getSubtopicString(topic);
		subNumber = getSubtopic(subChar);
		
		return subtopicPageTitles[section-1][subTopic-1][subNumber].length;
	}
	else
	{
		return pageTitles[section-1][topic-1].length;
	}
}

function getSubtopic(subString)
{
	var code;
	subString = subString.toLowerCase();
	
	if (subString.length == 2)
	{
		code = getSubtopic(subString.charAt(1));
		code += (((subString.charCodeAt(0) - 97) + 1)*26);
	}
	else
	{
		code = (subString.charCodeAt(0) - 97);
	}
	
	//alert("subTopic code for " + subString + " = " + code);
	return code;
}

function inSubtopic()
{
	return isSubtopic(topic);
}

function isSubtopic(theTopic)
{
	var value;
	var top = theTopic + '';
	top = top.toLowerCase();
	
	for (var i=0;i<top.length;i++)
	{
		value = top.charCodeAt(i);
		if ( (value > 96) && (value < 123) )
			return true;
	}
	
	return false;
}

function getSubtopicString(top)
{
	if (!isSubtopic(top)) return '';
	else
	{
		var value;
		top = top.toLowerCase();
		for (var i=0;i<top.length;i++)
		{
			value = top.charCodeAt(i);
			if ( (value > 96) && (value < 123) )
			{
				//alert(top.substring(i, top.length));
				return top.substring(i, top.length);
			}
		}
	}
}

function getPageTitle(sec, top, pag)
{
	if (isSubtopic(top))
	{
		return subtopicPageTitles[sec-1][parseInt(top)-1][getSubtopic(top.charAt(top.length-1))][pag-1];
	}
	else
	{
		return pageTitles[sec-1][top-1][pag-1];
	}
}

function getPageName()
{
	return (section + "t" + topic + "p" + page);
}

function pause(milis)
{
	var target;
	var now = new Date();
	target = now.getTime() + milis;
	
	while ( true )
	{
		now = new Date();
		if ( now.getTime() > target )
		{
			return;
		}
	}
}

function shutDown()
{
	LMSSetValue("cmi.core.lesson_location",section+","+topic+","+page);
	LMSCommit();
	LMSFinish();
}

// Returns the subtopic letter corresponding to
// an index value.  The algorithm used 
// assumes that 1 -> a, 2 -> b, ....
function getSubtopicLetter(index)
{
    var char1 = "";
    var char2 = "";
	var returnValue = ""
	
	if (index > 0)
	{
	    // First determine the high order letter (left letter)
	    if ((index % 26) == 0)
		{
	        if (index == 0)
			{
	            char2 = "";
			}
	        else
			{
	            char2 = "z";
			}
		}
	    else
		{
	        char2 = String.fromCharCode((index % 26) + 96);
		}
	    
	    // Now determine low order letter (right letter)
	    if (Math.floor((index - 1) / 26) == 0)
		{
	        char1 = "";
		}
	    else
		{
	        char1 = String.fromCharCode(Math.floor((index - 1) / 26) + 96);
		}
	    
	    // concatenate left and right letters together
	    // to get the answer.
	    returnValue = char1 + char2;
	}
	return returnValue;
}

function cleanUpURL(url)
{
	url = url + "";
	for (var i=0;i<url.length;i++)
	{
		if (url.charCodeAt(i) < 32 || url.charCodeAt(i) > 126)
		{
			//alert("Illegal Character Found at position " + i);
			url = url.slice(0,i) + url.slice(i+1,url.length);
		} 
		else if (url.charAt(i) == "\\")
		{
			url = url.slice(0,i) + "/" + url.slice(i+1,url.length);
		}
		else if (url.slice(i,i+3) == "%20")
		{
			url = url.slice(0,i) + " " + url.slice(i+3,url.length);
		}
	}
	
	var slashFound = false;
	for (var i=0;i<url.length;i++)
	{
		if (url.charAt(i) != "/" && slashFound)
		{
			url = url.slice(i,url.length);
			break;
		}
		else if (url.charAt(i) == "/")
		{
			slashFound = true;
		}
	}
	return url;
}
/*
var toolbarURL = cleanUpURL(document.location);
toolbarURL = toolbarURL.slice(0,toolbarURL.length-13);

if (navigator.appName == "Microsoft Internet Explorer")
{
	self.onerror = handleErrors;
}
else
{
	window.captureEvents(Event.onerror);
	window.onerror = handleErrors;

	parent.window.captureEvents(Event.onerror);
	parent.window.onerror = handleErrors;
}

function handleErrors(theDescription, theURL, theLineNumber)
{
	var filename = "";

	if (!ENABLE_ERROR_TRAPPING)
	{
		return false;
	}

	var theURL = cleanUpURL(theURL);
	var index = -1;
	for (var i=theURL.length-1;i>-1;i--)
	{
		if (theURL.slice(i,i+1) == "/")
		{
			index = i;
			filename = theURL.slice(i+1,theURL.length);
			break;
		}
	}
	if (index > -1)
	{
		theURL = theURL.slice(0,index);
	}
	else
	{
		filename = theURL;
	}

	if (theURL.indexOf(toolbarURL) != 0)
	{
		//alert("theURL: " + theURL + "\ntoolbarURL: " + toolbarURL);
		alert("LMS Error.  It is strongly recommended that you exit this courseware lesson immediately.  If you choose to continue, your lesson progress may not be successfully tracked." + "\n\nError in page, " + theURL + ", at line number " + theLineNumber + ":\n\n" + theDescription);
	}
	else if (ENABLE_ERROR_MESSAGES)
	{
		alert("Error in page, " + filename + ", at line number " + theLineNumber + ":\n\n" + theDescription);
	}
	else
	{
		window.defaultStatus = window.status = "Error on page " + section + "t" + topic + "p" + page + " line " + theLineNumber + ": " + theDescription;
	}
	enableCourseMapButton();
	return true;
}
*/
function isValidPage(section, topic, subtopic, page)
{
	if (subtopic == 0)
	{
		return (sectionTitles[section-1] != null && topicTitles[section-1][topic-1] != null && pageTitles[section-1] != null && pageTitles[section-1][topic-1] != null && pageTitles[section-1][topic-1][page-1] != null);
	}
	else
	{
		return (sectionTitles[section-1] != null && topicTitles[section-1][topic-1] != null && subtopicPageTitles[section-1] != null && subtopicPageTitles[section-1][topic-1] != null && subtopicPageTitles[section-1][topic-1][subtopic-1] != null && subtopicPageTitles[section-1][topic-1][subtopic-1][page-1] != null);
	}
}

function enableBackButton()
{
	backButtonEnabled = true;
	getImageRef("backButton").src = imageArray[BACK_IMG].src;
}

function disableBackButton()
{
	backButtonEnabled = false;
	getImageRef("backButton").src = imageArray[BACK_IMG+3].src;
}

function enableNextButton()
{
	nextButtonEnabled = true;
	getImageRef("nextButton").src = imageArray[NEXT_IMG].src;
}

function disableNextButton()
{
	nextButtonEnabled = false;
	getImageRef("nextButton").src = imageArray[NEXT_IMG+3].src;
}

